<?php

/*
	Form Definition

	Tabledefinition

	Datatypes:
	- INTEGER (Forces the input to Int)
	- DOUBLE
	- CURRENCY (Formats the values to currency notation)
	- VARCHAR (no format check, maxlength: 255)
	- TEXT (no format check)
	- DATE (Dateformat, automatic conversion to timestamps)

	Formtype:
	- TEXT (Textfield)
	- TEXTAREA (Textarea)
	- PASSWORD (Password textfield, input is not shown when edited)
	- SELECT (Select option field)
	- RADIO
	- CHECKBOX
	- CHECKBOXARRAY
	- FILE

	VALUE:
	- Wert oder Array

	Hint:
	The ID field of the database table is not part of the datafield definition.
	The ID field must be always auto incement (int or bigint).

	Search:
	- searchable = 1 or searchable = 2 include the field in the search
	- searchable = 1: this field will be the title of the search result
	- searchable = 2: this field will be included in the description of the search result


*/

$form["title"]    = "Mail Domain";
$form["description"]  = "";
$form["name"]    = "mail_domain";
$form["record_name_field"] = "domain";
$form["action"]   = "mail_domain_edit.php";
$form["db_table"]  = "mail_domain";
$form["db_table_idx"] = "domain_id";
$form["db_history"]  = "yes";
$form["tab_default"] = "domain";
$form["list_default"] = "mail_domain_list.php";
$form["auth"]   = 'yes'; // yes / no

$form["auth_preset"]["userid"]  = 0; // 0 = id of the user, > 0 id must match with id of current user
$form["auth_preset"]["groupid"] = 0; // 0 = default groupid of the user, > 0 id must match with groupid of current user
$form["auth_preset"]["perm_user"] = 'riud'; //r = read, i = insert, u = update, d = delete
$form["auth_preset"]["perm_group"] = 'riud'; //r = read, i = insert, u = update, d = delete
$form["auth_preset"]["perm_other"] = ''; //r = read, i = insert, u = update, d = delete

$form["tabs"]['domain'] = array (
	'title'  => "Domain",
	'width'  => 100,
	'template'  => "templates/mail_domain_edit.htm",
	'fields'  => array (
		//#################################
		// Begin Datatable fields
		//#################################
		'server_id' => array (
			'datatype' => 'INTEGER',
			'formtype' => 'SELECT',
			'default' => '',
			'datasource' => array (  'type' => 'SQL',
				'querystring' => 'SELECT server_id,server_name FROM server WHERE mail_server = 1 AND mirror_server_id = 0 AND {AUTHSQL} ORDER BY server_name',
				'keyfield'=> 'server_id',
				'valuefield'=> 'server_name'
			),
			'value'  => ''
		),
		'domain' => array (
			'datatype' => 'VARCHAR',
			'formtype' => 'TEXT',
			'filters'   => array( 0 => array( 'event' => 'SAVE',
					'type' => 'IDNTOASCII'),
				1 => array( 'event' => 'SHOW',
					'type' => 'IDNTOUTF8'),
				2 => array( 'event' => 'SAVE',
					'type' => 'TOLOWER')
			),
			'validators' => array (  0 => array ( 'type' => 'NOTEMPTY',
					'errmsg'=> 'domain_error_empty'),
				1 => array ( 'type' => 'UNIQUE',
					'errmsg'=> 'domain_error_unique'),
				2 => array ( 'type' => 'ISDOMAIN',
					'errmsg'=> 'domain_error_regex'),
			),
			'default' => '',
			'value'  => '',
			'width'  => '30',
			'maxlength' => '255',
			'searchable' => 1
		),
		'dkim' => array (
			'datatype'      => 'VARCHAR',
			'formtype'      => 'CHECKBOX',
			'default'       => 'n',
			'value'         => array(0 => 'n', 1 => 'y')
		),
		'dkim_private' => array (
			'datatype'      => 'TEXT',
			'formtype'      => 'TEXTAREA',
			'default'       => '',
			'value'         => '',
			'cols'          => '30',
			'rows'          => '10',
			'validators'    => array (  0 => array ('type'  => 'CUSTOM',
					'class' => 'validate_dkim',
					'function' => 'check_private_key',
					'errmsg'=> 'dkim_private_key_error'),
			),
		),
		'dkim_public' => array (
			'datatype'      => 'TEXT',
			'formtype'      => 'TEXTAREA',
			'default'       => '',
			'value'         => '',
			'cols'          => '30',
			'rows'          => '10'
		),
		'dkim_selector' => array (
			'datatype'      => 'VARCHAR',
			'formtype'      => 'TEXT',
			'default'       => 'default',
			'value'         => 'default',
			'width'  => '20',
			'maxlength' => '126',
			'validators' => array (  0 => array (   'type' => 'REGEX',
					'regex' => '/^[a-z0-9]{1,63}(?:\.[a-z0-9]{1,63})?$/',
					'errmsg'=> 'dkim_selector_error'),
			),
		),
		'relay_host' => array(
				'datatype' => 'VARCHAR',
				'formtype' => 'TEXT',
				'default' => '',
				'value' => '',
				'width' => '40',
				'maxlength' => '255'
		),
		'relay_user' => array(
				'datatype' => 'VARCHAR',
				'formtype' => 'TEXT',
				'default' => '',
				'value' => '',
				'width' => '40',
				'maxlength' => '255'
		),
		'relay_pass' => array(
				'datatype' => 'VARCHAR',
				'formtype' => 'TEXT',
				'default' => '',
				'value' => '',
				'width' => '40',
				'maxlength' => '255'
		),
		'active' => array (
			'datatype' => 'VARCHAR',
			'formtype' => 'CHECKBOX',
			'default' => 'y',
			'value'  => array(0 => 'n', 1 => 'y')
		),
		//#################################
		// END Datatable fields
		//#################################
	)
);


?>
