<?php
/*
Copyright (c) 2008, Till Brehm, projektfarm Gmbh
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.
    * Neither the name of ISPConfig nor the names of its contributors
      may be used to endorse or promote products derived from this software without
      specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

function replacePrefix($name, $dataRecord) {
	// No input -> no possible output -> go out!
	if ($name=="") return "";

	// Array containing keys to search
	$keywordlist=array('CLIENTNAME','CLIENTID','DOMAINID');

	// Try to match the key within the string
	foreach ($keywordlist as $keyword) {
		if (substr_count($name, '['.$keyword.']') > 0) {
			switch ($keyword) {
				case 'CLIENTNAME':
					$name=str_replace('['.$keyword.']', getClientName($dataRecord),$name);
				break;
				case 'CLIENTID':
					$name=str_replace('['.$keyword.']', getClientID($dataRecord),$name);
				break;
				case 'DOMAINID':
					$name=str_replace('['.$keyword.']', $dataRecord['parent_domain_id'],$name);
				break;
			}
		}
	}
	return $name;
}

function getClientName($dataRecord) {
    global $app, $conf;
    /* FS#1234 - CLIENTNAME value when in reseller account - need check this workarround impact */
    //if($_SESSION["s"]["user"]["typ"] != 'admin' || $app->auth->has_clients($_SESSION['s']['user']['userid'])) {
    if($_SESSION["s"]["user"]["typ"] != 'admin' && ! $app->auth->has_clients($_SESSION['s']['user']['userid'])) {
    	// Get the group-id of the user
    	$client_group_id = $_SESSION["s"]["user"]["default_group"];
    } else {
    	// Get the group-id from the data itself
    	if(isset($dataRecord['client_group_id'])) {
			$client_group_id = $dataRecord['client_group_id'];
		} elseif (isset($dataRecord['parent_domain_id'])) {
			$tmp = $app->db->queryOneRecord("SELECT sys_groupid FROM web_domain WHERE domain_id = " . $dataRecord['parent_domain_id']);
			$client_group_id = $tmp['sys_groupid'];
      	} else {
			$client_group_id = $dataRecord['sys_groupid'];
      	}
    }
	
    /* get the name of the client */
    $tmp = $app->db->queryOneRecord("SELECT name FROM sys_group WHERE groupid = " . $client_group_id);
    $clientName = $tmp['name'];
    if ($clientName == "") $clientName = 'default';
    $clientName = convertClientName($clientName);
    return $clientName;
}

function getClientID($dataRecord) {
    global $app, $conf;

    if($_SESSION["s"]["user"]["typ"] != 'admin' || $app->auth->has_clients($_SESSION['s']['user']['userid'])) {
    	// Get the group-id of the user
    	$client_group_id = $_SESSION["s"]["user"]["default_group"];
    } else {
    	// Get the group-id from the data itself
		if(isset($dataRecord['client_group_id'])) {
			$client_group_id = $dataRecord['client_group_id'];
      	} elseif (isset($dataRecord['parent_domain_id'])) {
			$tmp = $app->db->queryOneRecord("SELECT sys_groupid FROM web_domain WHERE domain_id = " . $dataRecord['parent_domain_id']);
			$client_group_id = $tmp['sys_groupid'];
		} else {
			$client_group_id = $dataRecord['sys_groupid'];
      	}
    }
    /* get the name of the client */
    $tmp = $app->db->queryOneRecord("SELECT client_id FROM sys_group WHERE groupid = " . $client_group_id);
    $clientID = $tmp['client_id'];
    if ($clientID == '') $clientID = '0';
    return $clientID;
}

function convertClientName($name){
	/**
	 *  only allow 'a'..'z', '_', '-', '0'..'9'
	 */
	$allowed = 'abcdefghijklmnopqrstuvwxyz0123456789_-';
	$res = '';
	$name = strtolower(trim($name));
	for ($i=0; $i < strlen($name); $i++){
		if ($name[$i] == ' ') continue;
		if (strpos($allowed, $name[$i]) !== false){
			$res .= $name[$i];
		}
		else {
			$res .= '_';
		}
	}
	return $res;
}


?>
