<?php

/*
	Form Definition

	Tabledefinition

	Datatypes:
	- INTEGER (Forces the input to Int)
	- DOUBLE
	- CURRENCY (Formats the values to currency notation)
	- VARCHAR (no format check, maxlength: 255)
	- TEXT (no format check)
	- DATE (Dateformat, automatic conversion to timestamps)

	Formtype:
	- TEXT (Textfield)
	- TEXTAREA (Textarea)
	- PASSWORD (Password textfield, input is not shown when edited)
	- SELECT (Select option field)
	- RADIO
	- CHECKBOX
	- CHECKBOXARRAY
	- FILE

	VALUE:
	- Wert oder Array

	Hint:
	The ID field of the database table is not part of the datafield definition.
	The ID field must be always auto incement (int or bigint).


*/

$form["title"] 			= "Database";
$form["description"] 	= "";
$form["name"] 			= "database";
$form["action"]			= "database_edit.php";
$form["db_table"]		= "web_database";
$form["db_table_idx"]	= "database_id";
$form["db_history"]		= "yes";
$form["tab_default"]	= "database";
$form["list_default"]	= "database_list.php";
$form["auth"]			= 'yes'; // yes / no

$form["auth_preset"]["userid"]  = 0; // 0 = id of the user, > 0 id must match with id of current user
$form["auth_preset"]["groupid"] = 0; // 0 = default groupid of the user, > 0 id must match with groupid of current user
$form["auth_preset"]["perm_user"] = 'riud'; //r = read, i = insert, u = update, d = delete
$form["auth_preset"]["perm_group"] = 'riud'; //r = read, i = insert, u = update, d = delete
$form["auth_preset"]["perm_other"] = ''; //r = read, i = insert, u = update, d = delete

$form["tabs"]['database'] = array (
	'title' 	=> "Database",
	'width' 	=> 100,
	'template' 	=> "templates/database_edit.htm",
	'fields' 	=> array (
	##################################
	# Begin Datatable fields
	##################################
		'server_id' => array (
			'datatype'	=> 'INTEGER',
			'formtype'	=> 'SELECT',
			'default'	=> '',
			'datasource'	=> array ( 	'type'	=> 'SQL',
										'querystring' => 'SELECT server_id,server_name FROM server WHERE mirror_server_id = 0 AND {AUTHSQL} AND db_server = 1 ORDER BY server_name',
										'keyfield'=> 'server_id',
										'valuefield'=> 'server_name'
									 ),
			'value'		=> ''
		),
		'type' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'SELECT',
			'default'	=> 'y',
			'value'		=> array('mysql' => 'MySQL')
		),
		'database_name' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'TEXT',
			'validators'	=> array ( 	0 => array (	'type'	=> 'NOTEMPTY',
														'errmsg'=> 'database_name_error_empty'),
										1 => array (	'type'	=> 'UNIQUE',
														'errmsg'=> 'database_name_error_unique'),
										2 => array (	'type'	=> 'REGEX',
														'regex' => '/^[a-zA-Z0-9_]{2,64}$/',
														'errmsg'=> 'database_name_error_regex'),
									),
			'default'	=> '',
			'value'		=> '',
			'width'		=> '30',
			'maxlength'	=> '255'
		),
		'database_user' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'TEXT',
			'validators'	=> array ( 	0 => array (	'type'	=> 'NOTEMPTY',
														'errmsg'=> 'database_user_error_empty'),
										1 => array (	'type'	=> 'UNIQUE',
														'errmsg'=> 'database_user_error_unique'),
										2 => array (	'type'	=> 'REGEX',
														'regex' => '/^[a-zA-Z0-9_]{2,64}$/',
														'errmsg'=> 'database_user_error_regex'),
									),
			'default'	=> '',
			'value'		=> '',
			'width'		=> '30',
			'maxlength'	=> '255'
		),
		'database_password' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'TEXT',
			'default'	=> '',
			'value'		=> '',
			'width'		=> '30',
			'maxlength'	=> '255'
		),
		'database_charset' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'SELECT',
			'default'	=> 'y',
			'value'		=> array('' => 'DB-Default','latin1' => 'Latin 1','utf8' => 'UTF-8')
		),
		'remote_access' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'CHECKBOX',
			'default'	=> 'n',
			'value'		=> array(0 => 'n',1 => 'y')
		),
		'active' => array (
			'datatype'	=> 'VARCHAR',
			'formtype'	=> 'CHECKBOX',
			'default'	=> 'y',
			'value'		=> array(0 => 'n',1 => 'y')
		),
	    'remote_ips' => array (
	      'datatype'  => 'TEXT',
	      'formtype'  => 'TEXT',
	      'validators'  => array (  0 => array (  'type' => 'CUSTOM',
	                                              'class' => 'validate_database',
	                                              'function' => 'valid_ip_list',
	                                              'errmsg' => 'database_remote_error_ips'),
	                             ),
	      'default' => '',
	      'value'   => '',
	      'width'   => '60'
	    ),
	##################################
	# ENDE Datatable fields
	##################################
	)
);


?>